/*
 * Copyright 2019 NXP
 * All rights reserved.
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _PDE_PREPROCESSING_H_
#define _PDE_PREPROCESSING_H_

///////////////////////////////////////////////////////////////////////////////////////////////////
//                                      Includes Section
///////////////////////////////////////////////////////////////////////////////////////////////////

#include <stdint.h>
#include <stdbool.h>

///////////////////////////////////////////////////////////////////////////////////////////////////
//                                  Defines & Macros Section
///////////////////////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////////////////////
//                                      Typedef Section
///////////////////////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////////////////////
//                                Function-like Macros Section
///////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////
//                                  Extern Constants Section
///////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////
//                                  Extern Variables Section
///////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////
//                                Function Prototypes Section
///////////////////////////////////////////////////////////////////////////////////////////////////

#if defined(__cplusplus)
extern "C" {
#endif // __cplusplus

void PDE_PreprocessingInit(void);

void PDE_PreprocessingSamples(int16_t * IqSamplesBuffer, uint16_t SamplesPerFreq, \
    uint16_t NumberFrequencies, int16_t * PhaseOutput, uint32_t *pMaskFreq);

void PDE_PreprocessingCombinePhases(int16_t * MdPhases, int16_t * RdPhases, int16_t * PhaseOutput, \
    uint16_t NumberOfFrequencies);

bool PDE_PreprocessingCombineFreqMasks(uint32_t * pLocalFreqMask,uint32_t * pRemoteFreqMask,\
    uint32_t * pFinalFreqMask, uint16_t NumberFrequencies);

void PDE_PreprocessingEnableFrequencyMask(bool isFrequencyMaskEnable);

void PDE_PreprocessingEnablePhaseMask(bool isPhaseMaskEnable);

bool PDE_PreprocessingGetFrequencyMaskStatus(void);

bool PDE_PreprocessingGetPhaseMaskStatus(void);

#if defined(__cplusplus)
}
#endif // __cplusplus


#endif /* _PDE_PREPROCESSING_H_ */
///////////////////////////////////////////////////////////////////////////////////////////////////
// EOF
///////////////////////////////////////////////////////////////////////////////////////////////////
